/****** Object:  StoredProcedure [dbo].[P_EST_PROD_PRECO_OFERTA_PERMANENTE]    Script Date: 04/02/2014 12:39:26 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_PRECO_OFERTA_PERMANENTE]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_PROD_PRECO_OFERTA_PERMANENTE]
GO
GO
--Versao 2941

CREATE PROCEDURE [dbo].[P_EST_PROD_PRECO_OFERTA_PERMANENTE] 
WITH 
	ENCRYPTION 
	AS  
SET NOCOUNT ON;
SET DEADLOCK_PRIORITY HIGH;
declare @CD_FILIAL INT;
 
	DECLARE filiais CURSOR FAST_FORWARD READ_ONLY
	FOR   
	SELECT distinct 
		a.CD_FILIAL   
	FROM 
		PRC_FILIAL   a 
		join EST_PROD_PRECO_OFERTA_PERMANENTE b on 
		A.CD_EMP = B.CD_EMP AND
		A.CD_FILIAL = B.CD_FILIAL
	WHERE 
		a.CD_EMP=1;
		
  
	OPEN filiais  
	FETCH NEXT FROM filiais INTO @CD_FILIAL  
	WHILE @@FETCH_STATUS=0  
		begin   
			PRINT 'Filial : ' + convert(varchar(10), @cd_filial);
			

			if exists(select top 1 EST_PROD_PRECO_OFERTA_PERMANENTE.cd_emp
						FROM         
							EST_PROD_PRECO_OFERTA_PERMANENTE with (nolock) INNER JOIN EST_PROD_PRECO ON 
							EST_PROD_PRECO_OFERTA_PERMANENTE.CD_EMP = EST_PROD_PRECO.CD_EMP AND 
							EST_PROD_PRECO_OFERTA_PERMANENTE.CD_FILIAL = EST_PROD_PRECO.CD_FILIAL AND 
							EST_PROD_PRECO_OFERTA_PERMANENTE.CD_PROD = EST_PROD_PRECO.CD_PROD
						WHERE
							EST_PROD_PRECO_OFERTA_PERMANENTE.VLR_OFERTA > 0 
							AND EST_PROD_PRECO_OFERTA_PERMANENTE.EXCLUSAO =0 
							and EST_PROD_PRECO.CD_EMP=1
							AND EST_PROD_PRECO.CD_FILIAL =@CD_FILIAL)
			begin
				PRINT 'Aplicando desconto permanente - Time '  + convert(varchar,getdate(),108);
				UPDATE
					EST_PROD_PRECO
				SET
					EST_PROD_PRECO.VLR_OFERTA = CASE WHEN  EST_PROD_PRECO_OFERTA_PERMANENTE.EXCLUSAO = 1 THEN 
													0 
												ELSE  
													CASE WHEN EST_PROD_PRECO.VLR_OFERTA = 0 THEN 
														EST_PROD_PRECO_OFERTA_PERMANENTE.VLR_OFERTA 
													ELSE
														CASE WHEN ISNULL(EST_PROD_PRECO_OFERTA_PERMANENTE.SOBREPOR_VLR_OFERTA_ATUAL,0) = 1 THEN
															EST_PROD_PRECO_OFERTA_PERMANENTE.VLR_OFERTA 
														ELSE
															EST_PROD_PRECO.VLR_OFERTA
														END
													END
												END ,
					EST_PROD_PRECO.PRECO_ESPECIFICO = CASE WHEN  EST_PROD_PRECO_OFERTA_PERMANENTE.EXCLUSAO = 1 THEN 
														0 
													ELSE 
														CASE WHEN EST_PROD_PRECO.VLR_OFERTA = 0 THEN 
															EST_PROD_PRECO_OFERTA_PERMANENTE.PRECO_ESPECIFICO
														ELSE
															CASE WHEN ISNULL(EST_PROD_PRECO_OFERTA_PERMANENTE.SOBREPOR_VLR_OFERTA_ATUAL,0) = 1 THEN
																EST_PROD_PRECO_OFERTA_PERMANENTE.PRECO_ESPECIFICO
															ELSE
																EST_PROD_PRECO.PRECO_ESPECIFICO
															END
														END
													END,
					EST_PROD_PRECO.CD_USU = EST_PROD_PRECO_OFERTA_PERMANENTE.CD_USU,
					EST_PROD_PRECO.DT_CAD = EST_PROD_PRECO_OFERTA_PERMANENTE.DT_CAD
				FROM         
					EST_PROD_PRECO_OFERTA_PERMANENTE INNER JOIN EST_PROD_PRECO ON 
					EST_PROD_PRECO_OFERTA_PERMANENTE.CD_EMP = EST_PROD_PRECO.CD_EMP AND 
					EST_PROD_PRECO_OFERTA_PERMANENTE.CD_FILIAL = EST_PROD_PRECO.CD_FILIAL AND 
					EST_PROD_PRECO_OFERTA_PERMANENTE.CD_PROD = EST_PROD_PRECO.CD_PROD
				WHERE
					EST_PROD_PRECO_OFERTA_PERMANENTE.VLR_OFERTA > 0 
					AND EST_PROD_PRECO_OFERTA_PERMANENTE.EXCLUSAO =0  
					and EST_PROD_PRECO.CD_EMP=1
					AND EST_PROD_PRECO.CD_FILIAL =@CD_FILIAL
			end

			if exists(select top 1 EST_PROD_PRECO_OFERTA_PERMANENTE.CD_EMP 
							FROM         
										EST_PROD_PRECO_OFERTA_PERMANENTE with (nolock) INNER JOIN EST_PROD_PRECO ON 
										EST_PROD_PRECO_OFERTA_PERMANENTE.CD_EMP = EST_PROD_PRECO.CD_EMP AND 
										EST_PROD_PRECO_OFERTA_PERMANENTE.CD_FILIAL = EST_PROD_PRECO.CD_FILIAL AND 
										EST_PROD_PRECO_OFERTA_PERMANENTE.CD_PROD = EST_PROD_PRECO.CD_PROD
									WHERE
										EST_PROD_PRECO_OFERTA_PERMANENTE.EXCLUSAO = 1 
										and EST_PROD_PRECO.CD_EMP=1
										AND EST_PROD_PRECO.CD_FILIAL =@CD_FILIAL)
			begin

				Print 'Cancelando desconto permanente - Time ' + convert(varchar,getdate(),108)
				UPDATE
					EST_PROD_PRECO
				SET
					EST_PROD_PRECO.VLR_OFERTA = 0 ,
					EST_PROD_PRECO.PRECO_ESPECIFICO = 0 
				FROM         
					EST_PROD_PRECO_OFERTA_PERMANENTE INNER JOIN EST_PROD_PRECO ON 
					EST_PROD_PRECO_OFERTA_PERMANENTE.CD_EMP = EST_PROD_PRECO.CD_EMP AND 
					EST_PROD_PRECO_OFERTA_PERMANENTE.CD_FILIAL = EST_PROD_PRECO.CD_FILIAL AND 
					EST_PROD_PRECO_OFERTA_PERMANENTE.CD_PROD = EST_PROD_PRECO.CD_PROD
				WHERE
					EST_PROD_PRECO_OFERTA_PERMANENTE.EXCLUSAO = 1 
					and EST_PROD_PRECO.CD_EMP=1
					AND EST_PROD_PRECO.CD_FILIAL =@CD_FILIAL;
			end

		
			if exists(select top 1	cd_emp 
						from 
							EST_PROD_PRECO_OFERTA_PERMANENTE with (nolock)
						WHERE
							EST_PROD_PRECO_OFERTA_PERMANENTE.EXCLUSAO = 1 	
							and EST_PROD_PRECO_OFERTA_PERMANENTE.CD_EMP=1
							AND EST_PROD_PRECO_OFERTA_PERMANENTE.CD_FILIAL =@CD_FILIAL)
			begin
				print 'Deletando descontos cancelados - Time ' + convert(varchar,getdate(),108);
				DELETE FROM
					EST_PROD_PRECO_OFERTA_PERMANENTE
				WHERE
					EST_PROD_PRECO_OFERTA_PERMANENTE.EXCLUSAO = 1 	
					and EST_PROD_PRECO_OFERTA_PERMANENTE.CD_EMP=1
					AND EST_PROD_PRECO_OFERTA_PERMANENTE.CD_FILIAL =@CD_FILIAL

				UPDATE  A SET PRECO_ESPECIFICO = 0
				from
				    EST_PROD_PRECO A
				    LEFT JOIN EST_PROD_PRECO_OFERTA_PERMANENTE B ON 
				    B.CD_EMP = A.CD_EMP
				    AND B.CD_FILIAL = A.CD_FILIAL
				    AND B.CD_PROD = A.CD_PROD
				WHERE 
				    B.CD_PROD IS NULL
				    AND A.PRECO_ESPECIFICO = 1
				    AND A.CD_EMP=1
				    AND a.CD_FILIAL =@CD_FILIAL;

			end

			FETCH NEXT FROM filiais INTO @CD_FILIAL  
		end  

	PRINT 'Concludo.'  
	CLOSE filiais  
	DEALLOCATE filiais  
